class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'The Observer'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    remove_tags_before = dict(id='main-article-info')
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['bd','hd','toolbox-popup','ft','promo-component gu-now','m-guardianbookshop promo-component','crumb-wrapper global','promo-component recipesearch-widget']}),
                   dict(name='div', attrs={'id':['footer','related','holiday-offers']}),
                   dict(name='ul', attrs={'class':['article-attributes']}),
                   dict(name='ul', attrs={'id':['content-actions','article-toolbox']}),
                    dict(name='p', attrs={'id':'stand-first'}),
                    dict(name='img'),]

    feeds          = [(u'World News', u'http://www.guardian.co.uk/theobserver/news/worldnews/rss'),
                          (u'UK News', u'http://www.guardian.co.uk/theobserver/news/uknews/rss'),
                          (u'Comment', u'http://www.guardian.co.uk/theobserver/news/comment/rss'),
                          (u'In Focus', u'http://www.guardian.co.uk/theobserver/news/focus/rss'),
                          (u'Agenda', u'http://www.guardian.co.uk/theobserver/new-review/agenda/rss'),
                          (u'Magazine', u'http://www.guardian.co.uk/theobserver/magazine/rss'),
                          (u'Features', u'http://www.guardian.co.uk/theobserver/new-review/features/rss'),
                          (u'Sport', u'http://www.guardian.co.uk/theobserver/sport/rss')
                        ]

						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup

    def print_version(self, url):
        return url + "/print"
